/**
 * PhiliusWSClient.java
 * @author Vagisha Sharma
 * May 24, 2010
 * @version 1.0
 */
package org.yeastrc.philius.ws;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;


/**
 * 
 */
public class PhiliusWSClient {

	public static void main(String[] args) {
		
		String inputFile = args[0]; // Path to file with input protein sequence
		
		StringBuilder sequence = new StringBuilder();
		BufferedReader reader = null;
		try {
			reader = new BufferedReader(new FileReader(inputFile));
			String line;
			while((line = reader.readLine()) != null) {
				sequence.append(line.trim());
			}
		} catch (IOException e) {
			System.err.println("Could not read input file: "+inputFile);
			e.printStackTrace();
		}
		finally {
			if(reader != null) try{reader.close();}catch(IOException e){}
		}
		
		
		if(sequence.length() == 0) {
			System.err.println("Input sequence cannot be empty");
			System.exit(1);
		}
		
		
		
		PhiliusPredictorService service = new PhiliusPredictorService();
		PhiliusPredictorDelegate port = service.getPhiliusPredictorPort();

		// Submit the job
		int token = 0;
		try {
			
			token = port.submitSequence(sequence.toString());
			System.out.println("Job submitted to Philius transmembrane prediction service. Job identifier is: "+token);
			
		} catch (PhiliusWSException_Exception e) {
			System.err.println("Error submitting job");
			e.printStackTrace();
			System.exit(1);
		}
		
		System.out.println("Waiting for results...\n");
		// Get the result
		PhiliusSequenceAnnotationWS psa = null;
		try {
			psa = port.getResults(token);
		} catch (PhiliusWSException_Exception e) {
			System.err.println("Error reading results");
			e.printStackTrace();
			System.exit(1);
		}
		
		System.out.println("Philius Prediction: "+psa.getTypeString());
		System.out.println("Confidence: "+psa.getTypeScore());
		System.out.println("\nPredicted Protein Segments:");
		System.out.println("Type\tStart\tEnd\tConfidence");
		for(PhiliusSegmentWS segment: psa.getSegments()) {

			System.out.println(
					segment.getTypeString()+"\t"
					+segment.getStart()+"\t"
					+segment.getEnd()+"\t"
					+segment.getTypeConfidence());
		}
	}
}
